package w83b.w83bOperacionesPaso.w83bListados.w83bActas;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.Region;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import w83b.w83bBeans.W83bListadosBean;
import w83b.w83bBeans.W83bUsuarioXLNetsBean;
import w83b.w83bUtilidades.W83bUtilidadesExcel;
import w83b.w83bUtilidadesComunes.W83bClsConstantes;
import w83b.w83bUtilidadesComunes.W83bUtilidades;
import w83b.w83bUtilidadesComunes.W83bUtilidadesN38API;
import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesi18n;
import es.ejie.frmk.listeners.base.Q70ListenerUtils;
import es.ejie.frmk.presentacion.operacion.paso.Q70ActionPasoOP;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;

// TODO: Auto-generated Javadoc
/**
 * The Class W83bTablaConveniosOP.java.
 *
 * @author Deusto Sistemas
 */
public class W83bTablaEmpresasVariosCentrosExcelAction extends Q70ActionPasoOP{


	
	protected void processOP(Q70ContextoEJIE contexto, ActionErrors errores, ActionMapping mapping,
			ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
		
		
	}

	protected ActionForward processForward(Q70ContextoEJIE contexto, ActionErrors errors, ActionMapping mapping, 
			ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {

		String strRutaExcel = Q70ListenerUtils.getApplicationProperty("RUTA_PLANTILLAS_EXCEL")+"plantillaExcelw83bEmpresasVariosCentros.xls";
		InputStream inputStream = W83bTablaEmpresasVariosCentrosExcelAction.class.getResourceAsStream(strRutaExcel);
		HSSFWorkbook wb = new HSSFWorkbook(inputStream);
		
		wb.setSheetName(0,"Hoja1"); // Creacin de la hoja
        HSSFSheet sheet = wb.getSheetAt(0); // Creacin de la hoja
        
        List listaEmpresasVariosCentros = (ArrayList)contexto.get("w83bResultadoListadosBean");
        W83bListadosBean listadoBean = (W83bListadosBean)contexto.get("w83bListadosBean");
        
        W83bUtilidadesExcel excel = new W83bUtilidadesExcel(wb);

        String idioma = (String)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA);
        
        W83bUtilidadesExcel.crearCabeceraPieEstandar(sheet, idioma,(W83bUsuarioXLNetsBean)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_USUARIO));      
        
        W83bUsuarioXLNetsBean usuario = (W83bUsuarioXLNetsBean)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_USUARIO);
        String provincia = W83bUtilidadesN38API.elegirProvinciaDelegacion(usuario.getPerfilXLNets());       
        
        HSSFRow row;
        HSSFCell cell;
        HSSFCell cell2;
        HSSFCell cell3;
        
        row = sheet.getRow((short)4); 
        cell = row.getCell((short)4);
        cell2 = row.getCell((short)5);
        sheet.addMergedRegion(new Region((short)4,(short)4,(short)4,(short)5)); //NOPMD
        StringBuffer tituloImagenEu = new StringBuffer();
        StringBuffer tituloImagenEs = new StringBuffer();
        
        tituloImagenEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.tituloImagenInforme_eu",idioma));
        tituloImagenEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.tituloImagenInforme_es",idioma));
        
        cell.setCellValue(tituloImagenEu.toString());
        cell = row.getCell((short)7); 
        cell2 = row.getCell((short)8);
        sheet.addMergedRegion(new Region((short)4,(short)7,(short)4,(short)8)); //NOPMD
        cell.setCellValue(tituloImagenEs.toString());
        tituloImagenEu = new StringBuffer();
        tituloImagenEs = new StringBuffer();
        if(W83bClsConstantes.CONSTANTE_SERVICIOS_CENTRALES.equals(provincia)){
        	tituloImagenEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.direccionTrabajo_eu",idioma));
        	tituloImagenEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.direccionTrabajo_es",idioma));
        }
        else if(W83bClsConstantes.CONSTANTE_ALAVA.equals(provincia)){
        	tituloImagenEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionAlava_eu",idioma));
        	tituloImagenEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionAlava_es",idioma));
        }else if(W83bClsConstantes.CONSTANTE_GIPUZKOA.equals(provincia)){
        	tituloImagenEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionGuipuzcoa_eu",idioma));
        	tituloImagenEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionGuipuzcoa_es",idioma));
        }else if(W83bClsConstantes.CONSTANTE_BIZKAIA.equals(provincia)){
        	tituloImagenEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionBizkaia_eu",idioma));        	
        	tituloImagenEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionBizkaia_es",idioma));        	
        }
        	
        
        
        
        row = sheet.getRow((short)6); 
        cell = row.getCell((short)4);
        cell2 = row.getCell((short)5);
        sheet.addMergedRegion(new Region((short)6,(short)4,(short)6,(short)5)); //NOPMD
        cell.setCellValue(tituloImagenEu.toString());
        
        cell = row.getCell((short)7); 
        cell2 = row.getCell((short)8);
        sheet.addMergedRegion(new Region((short)6,(short)7,(short)6,(short)8)); //NOPMD
        cell.setCellValue(tituloImagenEs.toString());
        
        
         //MAPEO FORMULARIO
        row = sheet.getRow((short)11); 
        cell = row.createCell((short)2);
        if(StringUtils.isNotEmpty(listadoBean.getDescTerritorio())){
        	cell.setCellValue(listadoBean.getDescTerritorio().toUpperCase());
        }
        cell.setCellStyle(excel.styleTexto9);
        
        cell = row.createCell((short)6); 
        sheet.addMergedRegion(new Region((short)11,(short)6,(short)11,(short)7)); //NOPMD
        if(StringUtils.isNotEmpty(listadoBean.getFechaEntradaDesde())){
        	cell.setCellValue(listadoBean.getFechaEntradaDesde());
        }
        cell.setCellStyle(excel.styleTexto9);
       
        cell = row.createCell((short)12); 
        sheet.addMergedRegion(new Region((short)11,(short)12,(short)11,(short)13)); //NOPMD
        if(StringUtils.isNotEmpty(listadoBean.getFechaEntradaHasta())){
        	cell.setCellValue(listadoBean.getFechaEntradaHasta());
        }
        cell.setCellStyle(excel.styleTexto9);
        
        
        for(int i=0;i<listaEmpresasVariosCentros.size();i++){
        	W83bListadosBean empresa=(W83bListadosBean)listaEmpresasVariosCentros.get(i);
        	row = sheet.createRow((short)14+i); // Creacin de la fila 1
        	
        	cell = row.createCell((short)0); 
        	if(StringUtils.isNotEmpty(empresa.getCif())){
        		cell.setCellValue(empresa.getCif());
        	}
        	cell.setCellStyle(estiloFilaCentro(i,excel));
        	
        	cell = row.createCell((short)1);
        	if(StringUtils.isNotEmpty(empresa.getCodCentro())){
        		cell.setCellValue(W83bUtilidades.numero(empresa.getCodCentro()));
        	}else{
        		cell.setCellValue("");
        	}

        	cell.setCellStyle(estiloFilaCentro(i,excel));
        	
        	cell = row.createCell((short)2); 
        	if(StringUtils.isNotEmpty(empresa.getNumActa())){
        		cell.setCellValue(empresa.getNumActa());
        	}
     		cell.setCellStyle(estiloFilaCentro(i,excel));
        	
        	cell = row.createCell((short)3); 
        	cell2 = row.createCell((short)4);
        	sheet.addMergedRegion(new Region((short)14+i,(short)3,(short)14+i,(short)4)); //NOPMD
        	if (W83bClsConstantes.CONSTANTE_CASTELLANO.equals(idioma)){
        		cell.setCellValue(W83bUtilidadesExcel.mayusculasCampoExcel(empresa.getConvenio()));
            }
            else{
            	cell.setCellValue(W83bUtilidadesExcel.mayusculasCampoExcel(empresa.getConvenioeu()));
            }
        	cell.setCellStyle(estiloFila(i,excel));
        	cell2.setCellStyle(estiloFila(i,excel));
        	
        	cell = row.createCell((short)5); 
        	cell2 = row.createCell((short)6); 
        	cell3 = row.createCell((short)7); 
        	sheet.addMergedRegion(new Region((short)14+i,(short)5,(short)14+i,(short)7)); //NOPMD
        	if(StringUtils.isNotEmpty(empresa.getRazon())){
        		cell.setCellValue(W83bUtilidadesExcel.mayusculasCampoExcel(empresa.getRazon()));
        	}
        	cell.setCellStyle(estiloFila(i,excel));
        	cell2.setCellStyle(estiloFila(i,excel));
        	cell3.setCellStyle(estiloFila(i,excel));
        	
        	cell = row.createCell((short)8); 
        	cell2 = row.createCell((short)9); 
        	sheet.addMergedRegion(new Region((short)14+i,(short)8,(short)14+i,(short)9)); //NOPMD
        	if(StringUtils.isNotEmpty(empresa.getDireccion())){
        		cell.setCellValue(W83bUtilidadesExcel.mayusculasCampoExcel(empresa.getDireccion()));
        	}
        	cell.setCellStyle(estiloFila(i,excel));
        	cell2.setCellStyle(estiloFila(i,excel));
        	
        	cell = row.createCell((short)10); 
        	cell2 = row.createCell((short)11); 
        	sheet.addMergedRegion(new Region((short)14+i,(short)10,(short)14+i,(short)11)); //NOPMD
        	if(StringUtils.isNotEmpty(empresa.getMunicipio())){
        		cell.setCellValue(W83bUtilidadesExcel.mayusculasCampoExcel(empresa.getMunicipio()));
        	}
        	cell.setCellStyle(estiloFila(i,excel));
        	cell2.setCellStyle(estiloFila(i,excel));
        	
        	cell = row.createCell((short)12); 
        	if(StringUtils.isNotEmpty(empresa.getCnae())){
        		cell.setCellValue(W83bUtilidades.numero(empresa.getCnae()));
        	}else{
        		cell.setCellValue("");
        	}

            cell.setCellStyle(estiloFilaCentro(i,excel));
        	
        	cell = row.createCell((short)13);
        	if(StringUtils.isNotEmpty(empresa.getCodpostal())){
        		cell.setCellValue(W83bUtilidades.numero(empresa.getCodpostal()));
        	}else{
        		cell.setCellValue("");
        	}

        	cell.setCellStyle(estiloFilaCentro(i,excel));
        	
        	cell = row.createCell((short)14);
        	if(StringUtils.isNotEmpty(empresa.getNumelectores())){
        		cell.setCellValue(W83bUtilidades.numero(empresa.getNumelectores()));
        	}else{
        		cell.setCellValue("");
        	}

        	cell.setCellStyle(estiloFilaNumero(i,excel));
        	
        	cell = row.createCell((short)15);
        	if(StringUtils.isNotEmpty(empresa.getNumcandidatos())){
        		cell.setCellValue(W83bUtilidades.numero(empresa.getNumcandidatos()));
        	}else{
        		cell.setCellValue("");
        	}

        	cell.setCellStyle(estiloFilaNumero(i,excel));
        }
        
		
        byte[] bytesExcel = W83bUtilidadesExcel.fncExcelToBytes(wb);
        
        response.setContentType("application/vnd.ms-excel");
        response.setContentLength(bytesExcel.length);
        response.setHeader("Content-disposition","attachment;filename=EmpresasVariosCentros.xls");
        response.getOutputStream().write(bytesExcel);
        response.getOutputStream().flush();

		
		return null;
	}
	
	private HSSFCellStyle estiloFila(int nFila, W83bUtilidadesExcel excel){
		if(nFila%2==0){
			return excel.styleTextoPar;
		}else{
			return excel.styleTextoImpar;			
		}
		
	}
	
	private HSSFCellStyle estiloFilaNumero(int nFila, W83bUtilidadesExcel excel){
		if(nFila%2==0){
			return excel.styleTextoParNumero;
		}else{
			return excel.styleTextoImparNumero;			
		}
		
	}
	
	private HSSFCellStyle estiloFilaCentro(int nFila, W83bUtilidadesExcel excel){
		if(nFila%2==0){
			return excel.styleTextoParNumeroCentrado;
		}else{
			return excel.styleTextoImparNumeroCentrado;			
		}
		
	}

}
